/* 
 *  SupervisorSideBar.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import javafx.scene.control.TabPane;
import javafx.scene.layout.VBox;

public class SupervisorSideBar {

    private final VBox sideBar;

    private final SupervisorIntrinsicsTab intrinsicsTab;
    private final UUITabBase uuiTab;
    private final SupervisorAttachedDataTab dataTab;

    public SupervisorSideBar(InteractionExecutor interactionExe, SupervisorDataGUI gui) {
        sideBar = new VBox();

        TabPane tabPane = new TabPane();

        intrinsicsTab = new SupervisorIntrinsicsTab();
        tabPane.getTabs().add(intrinsicsTab.getTab());

        uuiTab = new UUITabBase();
        tabPane.getTabs().add(uuiTab.getTab());

        dataTab = new SupervisorAttachedDataTab();
        tabPane.getTabs().add(dataTab.getTab());

        sideBar.getChildren().add(tabPane);
    }

    public VBox getSideBar() {
        return sideBar;
    }

    public void update(InteractionDataI data) {
        intrinsicsTab.update(data);
        dataTab.update(data);
        uuiTab.update(data);
    }
}
